/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIHardwareResourcesRestore {
    private static final int NUM_VALID_PARMS = 5;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_partitionId;
    private String m_partitionName;
    private String m_drcIndex;
    private Vector drcIndexVec = new Vector();
    private Vector partitionVec = new Vector();
    private String[] m_lparArry;
    private HashMap m_validParms = new HashMap(11, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_cecClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIHardwareResourcesRestore(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_cecClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("-l", null);
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_cecClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0238", null, null);
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        PIHSCLPARClient pIHSCLPARClient = null;
        String string2 = null;
        if (null != this.m_partitionId) {
            string2 = new String(this.m_partitionId + "*" + this.m_cecClient.getIntName());
            pIHSCLPARClient = this.m_factory.createLPARClient(this.m_cecClient.getIntName(), string2, true);
            if (null == pIHSCLPARClient) {
                throw new PIHscClientException("7003", "PIHscClientBundle", "7003", new String[]{this.m_partitionId}, null);
            }
            this.partitionVec.add(string2);
        } else if (null != this.m_partitionName) {
            pIHSCLPARClient = this.m_factory.createLPARClient(this.m_cecClient.getIntName(), this.m_partitionName, false);
            if (null == pIHSCLPARClient) {
                throw new PIHscClientException("7002", "PIHscClientBundle", "7002", new String[]{this.m_partitionName}, null);
            }
            this.partitionVec.add(pIHSCLPARClient.getIntName());
        }
        if (this.m_drcIndex != null) {
            this.drcIndexVec.add(this.m_drcIndex);
        }
        if (this.m_resourceType.equals("io") && 0 == this.partitionVec.size() && 0 == this.drcIndexVec.size()) {
            Vector vector = this.m_cecClient.getRecoverableIOSlots(null);
            PIIOSlotDataBean pIIOSlotDataBean = null;
            for (int i = 0; i < vector.size(); ++i) {
                pIIOSlotDataBean = (PIIOSlotDataBean)vector.get(i);
                if (IDebug.enabled()) {
                    System.out.println("bean.getOwner = " + pIIOSlotDataBean.getOwner());
                    System.out.println("bean.getDrcIndex = " + pIIOSlotDataBean.getDrcIndex());
                }
                this.partitionVec.add(pIIOSlotDataBean.getOwner() + "*" + this.m_cecClient.getIntName());
                this.drcIndexVec.add(pIIOSlotDataBean.getDrcIndex());
            }
        }
        if (this.m_resourceType.equals("proc")) {
            this.m_cecClient.recoverCPUResources(this.partitionVec);
        } else if (this.m_resourceType.equals("mem")) {
            this.m_cecClient.recoverMemResources(this.partitionVec);
        } else if (this.m_resourceType.equals("io")) {
            this.m_cecClient.recoverIoResources(this.partitionVec, this.drcIndexVec);
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        String[] stringArray = null;
        String string = new String();
        if (null == this.m_resourceType || !this.m_resourceType.equals("mem") && !this.m_resourceType.equals("proc") && !this.m_resourceType.equals("io")) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "-r";
        }
        if (null == this.m_managedSystem || this.m_managedSystem.length() == 0) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "-m";
        }
        if (null != this.m_resourceType && this.m_resourceType.equals("io")) {
            if (this.m_partitionName != null && this.m_partitionId != null && null == this.m_drcIndex) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + "-l";
            }
            if (this.m_partitionName == null) {
                System.out.println("PARTITION NAME = NULL");
            } else {
                System.out.println("PARTITION NAME != NULL");
            }
            if (this.m_partitionId == null) {
                System.out.println("PARTITION ID = NULL");
            } else {
                System.out.println("PARTITION ID != NULL");
            }
            if (null != this.m_drcIndex && this.m_partitionName == null && this.m_partitionId == null) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + "-p or --id";
            }
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        Object var2_2 = null;
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_partitionId = (String)hashMap.get("--id");
        this.m_partitionName = (String)hashMap.get("-p");
        this.m_drcIndex = (String)hashMap.get("-l");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "RSTHWRES_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIHardwareResourcesRestore pIHardwareResourcesRestore = new PIHardwareResourcesRestore(pIHSCCECClient, printStream, bl);
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIHardwareResourcesRestore.m_validParms);
            pIHardwareResourcesRestore.mapParameters(hashMap);
            pIHardwareResourcesRestore.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

